/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.pickup;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickupEntry;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public final class ExperiencePickup
implements IPickupEntry {
    private static final ResourceLocation ICON = LootJournal.key("textures/gui/experience.png");
    private static final long startTime = Util.m_137550_();
    private int amount;

    public ExperiencePickup(int amount) {
        this.amount = amount;
    }

    @Override
    public MutableComponent getDisplayName() {
        return (this.amount <= 1 ? Component.m_237115_((String)"pickup.loot_journal.experience_single") : Component.m_237110_((String)"pickup.loot_journal.experience_multiple", (Object[])new Object[]{this.amount})).m_130948_(LootJournal.CONFIG.experienceEntryStyle);
    }

    @Override
    public int getTotalAmount() {
        return 0;
    }

    @Override
    public void renderIcon(GuiGraphics graphics, long time) {
        float timer = (float)(Util.m_137550_() - startTime) * 0.005f;
        graphics.m_280163_(ICON, -8, -8, 0.0f, 0.0f, 16, 16, 16, 32);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f + 0.5f * (float)Math.cos(timer)));
        graphics.m_280163_(ICON, -8, -8, 0.0f, 16.0f, 16, 16, 16, 32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    @Override
    public boolean maybeMerge(IPickupEntry pickup) {
        if (!(pickup instanceof ExperiencePickup)) {
            return false;
        }
        ExperiencePickup other = (ExperiencePickup)pickup;
        this.amount += other.amount;
        return true;
    }

    @Override
    public boolean shouldDisplayTotalAmount() {
        return false;
    }
}

